<?php
	class sales_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function place_orders($data){
			$this->db->insert('prexc', $data); 
		}

		public function get_stock_list(){
			$this->db->select('a.*, b.product_id as p_id, b.product_name, b.brand_name, b.unit, b.description, b.srp');
			$this->db->from('stocks a');
			$this->db->join('product b', 'b.product_id = a.product_id');
			$this->db->order_by("brand_name", "ASC"); 
			return $this->db->get()->result_object(); 
		}

		public function sales_history_search($data){
			$this->db->select('a.sales_id,a.product_id, a.stock_id, a.quantity, a.price_sold, a.date_sold,a.transaction_id,a.sold_to,a.used_points,a.remarks, b.product_id as p_id, b.product_name, b.brand_name, b.unit, c.product_id, c.supplier_price, d.customers_id,d.fname,d.lname');
			$this->db->from('sales a');
			$this->db->join('stocks c', 'c.stock_id = a.stock_id');
			$this->db->join('product b', 'b.product_id = c.product_id');
			$this->db->join('customers d', 'd.customers_id = a.sold_to','LEFT');
			if($data->date_from != ""){
				$date_from = date('Y-m-d H:i:s', strtotime($data->date_from." 00:00:00")); 
				$this->db->WHERE('a.date_sold >=',$date_from);
			}
			if($data->date_to != ""){
				$date_to = date('Y-m-d H:i:s', strtotime($data->date_to." 23:59:59"));
				$this->db->where('a.date_sold <=', $date_to);
			}
			if($data->product_id != ""){
			$this->db->where('b.product_id', $data->product_id);
			}
			if($data->remarks != ""){
			$this->db->like('a.remarks', $data->remarks);
			}
			if($data->sold_to != ""){
			$this->db->where('a.sold_to', $data->sold_to);
			}
			$this->db->order_by("sales_id", "desc");
			$query = $this->db->get(); 
			return $query->result();
		}
		public function sales_history(){
			$date = strtotime('today midnight');
			$today = date('Y-m-d H:i:s',$date);
			$this->db->select('a.sales_id, a.stock_id, a.quantity, a.price_sold, a.date_sold,a.transaction_id,a.sold_to,a.used_points,a.remarks, b.product_id as p_id, b.product_name, b.brand_name, b.unit, c.product_id, c.supplier_price, d.customers_id,d.fname,d.lname');
			$this->db->from('sales a');
			$this->db->join('stocks c', 'c.stock_id = a.stock_id');
			$this->db->join('product b', 'b.product_id = c.product_id');
			$this->db->join('customers d', 'd.customers_id = a.sold_to','LEFT');
			$this->db->WHERE('a.date_sold >=',$today);
			$this->db->order_by("sales_id", "desc");
			$query = $this->db->get(); 
			return $query->result();
		}
		public function get_last_trans(){
			$this->db->select('transaction_id');
			$this->db->from('sales');
			$this->db->order_by("sales_id", "desc");
			$this->db->limit(1);
			$query = $this->db->get(); 
			$result = $query->result();
			return $result[0]->transaction_id;
		}

		public function submit_orders($data){
			$num = count($data->stock_id);
			
			//var_dump($newdata->field);
			for ($i = 0; $i < $num; $i++) {
				$insert_data[] = array(
				'stock_id' => $data->stock_id[$i],
				'product_id' => $data->product_id[$i],
				'quantity' => $data->quantity[$i],
				'price_sold' => $data->price_sold[$i],
				'date_sold' => $data->date_sold,
				'used_points' => $data->used_points,
				'transaction_id' => $data->transaction_id,
				'sold_to' => $data->sold_to,
				'remarks' => $data->remarks,
				'used_points' => $data->used_points,
			);
		}
			$this->db->insert_batch('sales', $insert_data);
	}
		public function add_quantity_sold($data){
			$num = count($data->stock_id);
			
			//var_dump($newdata->field);
			for ($i = 0; $i < $num; $i++) {
			$this->db->set('quantity_sold', 'quantity_sold+'.$data->quantity[$i], FALSE);
			$this->db->set('current_profit', 'current_profit+'.$data->price_sold[$i], FALSE);
			$this->db->where('stock_id', $data->stock_id[$i]);
			$this->db->update('stocks'); 
			//echo $this->db->last_query();
		}
	}
		public function decrease_stocks($data){
			$num = count($data->stock_id);
			
			//var_dump($newdata->field);
			for ($i = 0; $i < $num; $i++) {
			$this->db->set('total_stocks', 'total_stocks-'.$data->quantity[$i], FALSE);
			$this->db->where('product_id', $data->product_id[$i]);
			$this->db->update('product'); 
		}
	}
		public function void_trans($data){
			$this->db->delete('sales', array('sales_id' => $data->sales_id)); 
	}
		public function void_stock($data){
			$this->db->set('quantity_sold', 'quantity_sold-'.$data->quantity, FALSE);
			$this->db->set('current_profit', 'current_profit-'.$data->total_price, FALSE);
			$this->db->where('stock_id', $data->stock_id);
			$this->db->update('stocks'); 
	}
		public function void_product($data){
			$this->db->set('total_stocks', 'total_stocks+'.$data->quantity, FALSE);
			$this->db->where('product_id', $data->product_id);
			$this->db->update('product'); 
	}
		
		
	}
?>

