<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Allotment Class Budget
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Tables</a></li>
        <li class="active">Data tables</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-xs-12 col-md-2 pull-right">
                <!-- <select class="form-control " name="year">
                    <?php // for($year=date("Y"); $year <= (date("Y") + 2); $year++): ?>
                        <option value="<?//=$year?>"><?//=$year?></option>
                    <?php // endfor; ?>
                </select> -->
                <select class="form-control" name="year">
                    <option value="<?=date("Y")?>"><?=date("Y")?></option>
                </select>
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Budget List</h3>
                        <div class="box-tools">
                            <a class="btn"  id="show_add_data_modal">
                                <i class="fa fa-plus"></i> Add Budget
                            </a>
                        </div>
                </div>
                <div class="box-body table-responsive">
                    <table class="table table-bordered">
                        <tr>
                            <th>Allotment Class</th>
                            <th style="width: 100px; text-align:center">Amount</th>
                            <th style="width: 100px; text-align:center">Action</th>
                        </tr>
                        <?php $total_allotment_class_budget_list = 0; ?>
                        <?php foreach($allotment_class_budget_list as $acbl): ?>
                            <?php $total_allotment_class_budget_list += $acbl->amount; ?>
                            <tr>
                                <td><?=$acbl->allotment_class_name?></td>
                                <td  style="width: 100px; text-align:center"><?=$acbl->amount?></td>
                                <td  style="width: 100px; text-align:center" >
                                    <a class="history" title="history">
                                        <i class="fa  fa-history"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <tr>
                                <td style="text-align:right" ><strong>Total<strong></td>
                                <td style="width: 100px; text-align:center"><strong><?=$total_allotment_class_budget_list?></strong></td>
                                <td style="width: 100px; text-align:center" ></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="add_data_modal">
        <div class="modal-dialog">
            <form method="POST" action="<?php echo base_url(); ?>allotment/add_allotment_class_budget" id="add_alottment_class_budget">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Add Budget</h4>
                </div>
                <div class="modal-body">
                    <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                        <p>Insufficient funds, Please check.</p>
                    </div>
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                            <label>Capital Outlay</label>
                                <input type="number" name="amount[1]" class="add_budget_amount form-control" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                            <label>Financial Expenses</label>
                                <input type="number"  name="amount[2]" class="add_budget_amount form-control" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                            <label>Maintenance and Other Operating Expense</label>
                                <input type="number" name="amount[3]" class="add_budget_amount form-control" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                            <label>Personnel Services</label>
                                <input type="number"  name="amount[4]" class="add_budget_amount form-control" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                            <label>Description</label>
                                <textarea   name="description"  class="form-control" ></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="add_budget_btn">Add</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
        </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#show_add_data_modal").click(function() {
            $("#add_data_modal").modal("show");
        });
        
        $("#add_budget_btn").click(function() {
            $("#add_error_message").hide();
            var total_new_budget_amount = 0;
            $("input.add_budget_amount").each(function(){
                if (/^\d+$/.test($(this).val())) {
                    total_new_budget_amount +=  parseInt($(this).val()); 
                } else {
                    $(this).val(0);
                }
            });

            if(total_new_budget_amount > 0) {
                $.post('<?=base_url();?>allotment/get_available_fund_budget',{},
                    function(e){
                        if(e.available_amount >= total_new_budget_amount) {
                            $("form#add_alottment_class_budget").submit(); 
                        } else {
                            $("#add_error_message").show();
                            $("#add_error_message").html("<p>Insufficient funds, Please check.</p>");
                        }
                    }
                );
            } else {
                $("#add_error_message").show();
                $("#add_error_message").html("<p>Total budget amount must greater than zero.</p>");
            }
        });
    });
</script>