  <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
  <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
  <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
  <link rel="stylesheet" href="/resources/demos/style.css">
<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        Expenses
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Tables</a></li>
        <li class="active">Data tables</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                    <h3 class="box-title">Expenses List</h3>
                        <div class="box-tools">
                            <button class="btn btn-info" id="add_expenses" >
                                <i  class="fa fa-plus fa-1x"> </i> Add Expenses
                            </button>
                        </div>
                    </div>
                <div class="box-body table-responsive">
                    <div class="modal fade" id="add_expenses_modal" tabindex="-1" role="dialog" 
                         aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <!-- Modal Header -->
                                <div class="modal-header">
                                    <button type="button" class="close" 
                                       data-dismiss="modal">
                                           <span aria-hidden="true">&times;</span>
                                           <span class="sr-only">Close</span>
                                    </button>
                                    <h4 class="modal-title" id="myModalLabel">
                                        <p id="modal_title"></p>
                                    </h4>
                                </div>
                                
                                <!-- Modal Body -->
                                <div class="modal-body">
                                    
                                  <form method="POST" class="form-horizontal" role="form" action="<?php echo base_url()."expenses/add_expenses"; ?>">
                                     <table class="table table-bordered table-hover">
                                       <tr>
                                            <td>Type: </td>
                                            <td>
                                              <select name="type" class="form-control select2" required="required">
                                                <option value="Rent">Rent</option>
                                                <option value="Salary">Salary</option>
                                                <option value="Gasoline">Gasoline</option>
                                                <option value="Electricity">Electricity</option>
                                                <option value="Water">Water Bill</option>
                                                <option value="personal">Personal</option>
                                                <option value="others">Others</option>
                                              </select>
                                            </td>
                                        </tr>
                                       <tr>
                                            <td>Details: </td>
                                            <td><textarea name="details" class="form-control" required="required"></textarea></td>
                                        </tr>
                                       <tr>
                                            <td>Amount: </td>
                                            <td><input type="text" name="amount" class="form-control" required="required"/></td>
                                        </tr>
                                       <tr>
                                            <td>Date: </td>
                                            <td><input type="text" name="date" id="datepicker" class="form-control" required="required"/></td>
                                        </tr>
                                     </table>
                                      <!--SUBMIT BUTTON -->
                                    <div class="modal-footer" align="right">
                                      <div class="form-group">
                                        <div class="col-sm-12" align="right">
                                          <button type="button" class="btn btn-default" data-dismiss="modal">
                                             Close
                                          </button>
                                          <button type="submit" class="btn btn-success">Add</button>
                                        </div>
                                      </div>
                                     </div>
                                    </form>
                                </div><!--end Modal body-->
                            </div><!--end Modal content-->
                        </div><!--end Modal dialog-->
                    </div><!--end modal receive-->
                <hr />
                   <table class="table table-striped table-bordered table-hover" id="viewresult">
                        <thead>
                            <tr >
                              <th width="20%">Type</th>
                              <th width="20%">Details</th>
                              <th width="20%">Amount</th>
                              <th width="20%">date</th>
                              <th width="20%">action</th>
                            </tr>
                        </thead>
                        <?php 
                        if($expenses_list != false){
                            foreach($expenses_list as $expenses){ 
                        ?>
                        <tr>
                            <td><?php echo $expenses->type; ?></td>
                            <td><?php echo $expenses->details; ?></td>
                            <td><?php echo $expenses->amount; ?></td>
                            <td><?php echo $expenses->date; ?></td>
                            <td>            
                              <a class="edit_modal" href="#" etype="<?php echo $expenses->type; ?>" expenses_id="<?php echo $expenses->expenses_id; ?>" details="<?php echo $expenses->details; ?>" amount="<?php echo $expenses->amount; ?>" date="<?php echo $expenses->date; ?>" " >
                                   <i class="fa fa-edit"></i> 
                               </a> |
                            </td>
                        </tr>
                        <?php 
                            }
                        }
                        ?>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

</div>

<div class="modal fade" id="edit_expenses" tabindex="-1" role="dialog" 
     aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <button type="button" class="close" 
                   data-dismiss="modal">
                       <span aria-hidden="true">&times;</span>
                       <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">
                    Edit expenses
                </h4>
            </div>
            <!-- Modal Body -->
            <div class="modal-body">
              <form id="edit_form" method="POST" class="form-horizontal" role="form" action="<?php echo base_url()."expenses/edit_expenses"; ?>">
               <input type="hidden" name="expenses_id" id="expenses_id">
               <table class="table table-bordered table-hover">
                 <tr>
                      <td>Type: </td>
                      <td>
                        <select name="type" id="type" class="form-control">
                          <option value="Rent">Rent</option>
                          <option value="Salary">Salary</option>
                          <option value="Gasoline">Gasoline</option>
                          <option value="Electricity">Electricity</option>
                          <option value="Water">Water Bill</option>
                          <option value="Personal">Personal</option>
                          <option value="Others">Others</option>
                        </select>
                      </td>
                  </tr>
                 <tr>
                      <td>Details: </td>
                      <td><textarea name="details" id="details" class="form-control"></textarea></td>
                  </tr>
                 <tr>
                      <td>Amount: </td>
                      <td><input type="text" name="amount" id="amount" class="form-control" /></td>
                  </tr>
                 <tr>
                      <td>Date: </td>
                      <td><input type="text" name="date" id="datepicker1" class="form-control" /></td>
                  </tr>
               </table>
                     
                  <!--SUBMIT BUTTON -->
                <div class="modal-footer" align="right">
                  <div class="form-group">
                    <div class="col-sm-12" align="right">
                      <button type="button" class="btn btn-default" data-dismiss="modal">
                         Close
                      </button>
                      <input type="submit" value="Update" class="btn btn-success">
                    </div>
                  </div>
                </div>
              </form>
            </div><!--end Modal body-->
        </div><!--end Modal content-->
    </div><!--end Modal dialog-->
  </div><!--end modal receive-->

<script>
$(document).ready(function() {
  $("#add_expenses").click(function() {
      $("#modal_title").text('Add Expenses');
      $('#add_expenses_modal').modal('show');
});

  $(".edit_modal").click(function() {
      var etype = this.getAttribute("etype");
      var details = this.getAttribute("details");
      var amount = this.getAttribute("amount");
      var date = this.getAttribute("date");
      var expenses_id = this.getAttribute("expenses_id");
      $('option[value=' + etype + ']').attr('selected',true);
      $("#details").val(details);
      $("#amount").val(amount);
      $("#datepicker1").val(date);
      $("#expenses_id").val(expenses_id);
      $('#edit_expenses').modal('show');
  });

    $('#viewresult').DataTable({
            responsive: true,
    "aLengthMenu": [[5, 10, 20, -1], [5, 10, 20, "All"]],
    "iDisplayLength": 10
    });


    $( "#datepicker" ).datepicker({
    changeYear:true,
    changeMonth: true,
    yearRange: "2018:2030",
    dateFormat: 'yy-mm-dd'
    });
    $( "#datepicker1" ).datepicker({
    changeYear:true,
    changeMonth: true,
    yearRange: "2018:2030",
    dateFormat: 'yy-mm-dd'
    });
  
});
</script>

